#!/usr/bin/python

import sys
import math
import numpy as np

#12th July: planes calculations

def dihedral_angle(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4):

	#define points
	p1 = np.array([x1, y1, z1])	#donor
	p2 = np.array([x2, y2, z2])	#C_don
	p3 = np.array([x3, y3, z3])	#accept
	p4 = np.array([x4, y4, z4])	#C_acc

	#find coefficients for plane: C_donor - donor - acceptor
	v1 = p3 - p1
	v2 = p2 - p1
	cp1 = np.cross(v1, v2)

	#find coefficients for plane: C_accept - accept - donor
	v1 = p3 - p1
	v2 = p4 - p1
	cp2 = np.cross(v1, v2)

	#calculate dihedral angle cosine:

	return np.arccos(np.dot(cp1,cp2)/np.sqrt((np.dot(cp1,cp1)*np.dot(cp2,cp2))))

#19th July: aromatic hydrogen bonds

def aromatic5(a1,a2,a3,a4,a5,aa,beg):
	# returns already prepared string for acceptor list
	# takes strings of coordinates as data

	dict = {"HIS":"X1 ", "TRP":"X4 "}

	xCacc = (float(a1[0:8]) + float(a2[0:8]) + float(a3[0:8]) + float(a4[0:8]) + float(a5[0:8]))/5
	yCacc = (float(a1[8:16]) + float(a2[8:16]) + float(a3[8:16]) + float(a4[8:16]) + float(a5[8:16]))/5
	zCacc = (float(a1[16:24]) + float(a2[16:24]) + float(a3[16:24]) + float(a4[16:24]) + float(a5[16:24]))/5

	xM = np.array([xCacc, yCacc, zCacc])
	x1 = np.array([float(a1[0:8]), float(a1[8:16]), float(a1[16:24])])
	x2 = np.array([float(a2[0:8]), float(a2[8:16]), float(a2[16:24])])
	per = np.cross(x1 - xM, x2 - xM)

	per = 1.7*per/np.sqrt(np.dot(per,per))

	x1 = xM + per
	x2 = xM - per
	
	string1 = beg+" "+dict[aa]+" "+(8-len(str(round(x1[0],3))))*" " + str(round(x1[0],3)) + (8-len(str(round(x1[1],3))))*" " + str(round(x1[1],3)) + (8-len(str(round(x1[2],3))))*" " + str(round(x1[2],3)) + (8-len(str(round(xM[0],3))))*" " + str(round(xM[0],3)) + (8-len(str(round(xM[1],3))))*" " + str(round(xM[1],3)) + (8-len(str(round(xM[2],3))))*" " + str(round(xM[2],3)) + " " + "AROM__COMPL"

	string2 = beg+" "+dict[aa]+" "+(8-len(str(round(x2[0],3))))*" " + str(round(x2[0],3)) + (8-len(str(round(x2[1],3))))*" " + str(round(x2[1],3)) + (8-len(str(round(x2[2],3))))*" " + str(round(x2[2],3)) + (8-len(str(round(xM[0],3))))*" " + str(round(xM[0],3)) + (8-len(str(round(xM[1],3))))*" " + str(round(xM[1],3)) + (8-len(str(round(xM[2],3))))*" " + str(round(xM[2],3)) + " " + "AROM__COMPL" 

	return [string1,string2]
	
def aromatic6(a1,a2,a3,a4,a5,a6,aa,beg):
	# returns already prepared string for acceptor list
	# takes strings of coordinates as data

	dict = {"TYR":"X2 ", "PHE":"X3 ", "TRP":"X5 "}

	xCacc = (float(a1[0:8]) + float(a2[0:8]) + float(a3[0:8]) + float(a4[0:8]) + float(a5[0:8]) + float(a6[0:8]))/6
	yCacc = (float(a1[8:16]) + float(a2[8:16]) + float(a3[8:16]) + float(a4[8:16]) + float(a5[8:16]) + float(a6[8:16]))/6
	zCacc = (float(a1[16:24]) + float(a2[16:24]) + float(a3[16:24]) + float(a4[16:24]) + float(a5[16:24]) + float(a6[16:24]))/6

	xM = np.array([xCacc, yCacc, zCacc])
	x1 = np.array([float(a1[0:8]), float(a1[8:16]), float(a1[16:24])])
	x2 = np.array([float(a3[0:8]), float(a3[8:16]), float(a3[16:24])])
	
	per = np.cross(x1 - xM, x2 - xM)
	per = 1.7*per/np.sqrt(np.dot(per,per))

	x1 = xM + per
	x2 = xM - per
	
	string1 = beg+" "+dict[aa]+" "+(8-len(str(round(x1[0],3))))*" " + str(round(x1[0],3)) + (8-len(str(round(x1[1],3))))*" " + str(round(x1[1],3)) + (8-len(str(round(x1[2],3))))*" " + str(round(x1[2],3)) + (8-len(str(round(xM[0],3))))*" " + str(round(xM[0],3)) + (8-len(str(round(xM[1],3))))*" " + str(round(xM[1],3)) + (8-len(str(round(xM[2],3))))*" " + str(round(xM[2],3)) + " " + "AROM__COMPL"

	string2 = beg+" "+dict[aa]+" "+(8-len(str(round(x2[0],3))))*" " + str(round(x2[0],3)) + (8-len(str(round(x2[1],3))))*" " + str(round(x2[1],3)) + (8-len(str(round(x2[2],3))))*" " + str(round(x2[2],3)) + (8-len(str(round(xM[0],3))))*" " + str(round(xM[0],3)) + (8-len(str(round(xM[1],3))))*" " + str(round(xM[1],3)) + (8-len(str(round(xM[2],3))))*" " + str(round(xM[2],3)) + " " + "AROM__COMPL"

	return [string1,string2]


#some easy supporting functions
def sumvector(vect, a, b):	#this will also sum vect[b]
	suma=vect[a]
	if  b<a:
		return 0
	else:
		while (a!=b):
			a=a+1
			suma=suma+vect[a]
		return suma

def center2d(a,b):
	x=str(round((float(a[0:8])+float(b[0:8]))/2,3))
	y=str(round((float(a[8:16])+float(b[8:16]))/2,3))
	z=str(round((float(a[16:])+float(b[16:]))/2,3))
	result=" "*(8-len(x)) + x + " "*(8-len(y)) + y + " "*(8-len(z)) + z
	return result

def center3d(a,b,c):
	x=str(round((float(a[0:8])+float(b[0:8]) + float(c[0:8]))/3,3))
	y=str(round((float(a[8:16])+float(b[8:16]) + float(c[8:16]))/3,3))
	z=str(round((float(a[16:])+float(b[16:]) + float(c[16:]))/3,3))
	result=" "*(8-len(x)) + x + " "*(8-len(y)) + y + " "*(8-len(z)) + z
	return result

def center4d(a,b,c,d):
	x=str(round((float(a[0:8])+float(b[0:8])+float(c[0:8]) + float(d[0:8]))/4,3))
	y=str(round((float(a[8:16])+float(b[8:16])+float(c[8:16]) + float(d[8:16]))/4,3))
	z=str(round((float(a[16:])+float(b[16:])+float(c[16:]) + float(d[16:]))/4,3))
	result=" "*(8-len(x)) + x + " "*(8-len(y)) + y + " "*(8-len(z)) + z
	return result

def center5d(a,b,c,d,e):
	x=str(round((float(a[0:8])+float(b[0:8])+float(c[0:8]) + float(d[0:8]) + float(e[0:8]))/5,3))
	y=str(round((float(a[8:16])+float(b[8:16])+float(c[8:16]) + float(d[8:16]) + float(e[8:16]))/5,3))
	z=str(round((float(a[16:])+float(b[16:])+float(c[16:]) + float(d[16:]) + float(e[16:]))/5,3))
	result=" "*(8-len(x)) + x + " "*(8-len(y)) + y + " "*(8-len(z)) + z
	return result

def subtract(a):
	if a==0:
		return a
	else:
		return (a-1)

def maks(a,b):
	if a>=b:	
		return a
	else:
		return b

#9th October: add function for double neighbourhood
def double_neigh(bonds_vect, i,j,k, pdb):
	ar = []
	res = []
	for o in range(0, len(bonds_vect)):
		ar.append(int(bonds_vect[o]))

	p = ar[i]	#central
	q = ar[j]	#neigh1
	r = ar[k]	#neigh2

	if p>0 and q>0 and r>0:
		while (p+q+r)>0:
			p=subtract(p)
			q=subtract(q)
			r=subtract(r)
			"""
			print pdb
			print str(i)+ str(j) + str(k)
			print bonds_vect
			"""
			string = pdb[sumvector(ar,0,i-1)+p][17:26]+" "+pdb[sumvector(ar,0,i-1)+p][13:17]+ pdb[sumvector(ar,0,i-1)+p][30:54] +center2d(pdb[sumvector(ar,0,j-1)+q][30:54], pdb[sumvector(ar,0,k-1)+r][30:54]) +" "+ pdb[sumvector(ar,0,i-1)+p][55:66]
			res.append(string)
	return res

def triple_neigh(bonds_vect, i,j,k,l, pdb):
	ar = []
	res = []
	for o in range(0, len(bonds_vect)):
		ar.append(int(bonds_vect[o]))

	p = ar[i]	#central
	q = ar[j]	#neigh1
	r = ar[k]	#neigh2
	s = ar[l]	#neigh3

	if p>0 and q>0 and r>0 and s>0:
		while (p+q+r+s)>0:
			p=subtract(p)
			q=subtract(q)
			r=subtract(r)
			s=subtract(s)
			string = pdb[sumvector(ar,0,i-1)+p][17:26]+" "+pdb[sumvector(ar,0,i-1)+p][13:17]+ pdb[sumvector(ar,0,i-1)+p][30:54] +center3d(pdb[sumvector(ar,0,j-1)+q][30:54], pdb[sumvector(ar,0,k-1)+r][30:54], pdb[sumvector(ar,0,l-1)+s][30:54]) +" "+ pdb[sumvector(ar,0,i-1)+p][55:66]
			res.append(string)
	return res

def six_neigh(bonds_vect, i,j,k,l,m,n, pdb):
	ar = []
	res = []
	for o in range(0, len(bonds_vect)):
		ar.append(int(bonds_vect[o]))

	p = ar[i]	#central
	q = ar[j]	#neigh1
	r = ar[k]	#neigh2
	s = ar[l]	#neigh3
	t = ar[m]	#neigh4
	u = ar[n]	#neigh5

	if p>0 and q>0 and r>0 and s>0 and t>0 and u>0:
		while (p+q+r+s+t+u)>0:
			p=subtract(p)
			q=subtract(q)
			r=subtract(r)
			s=subtract(s)
			t=subtract(t)
			u=subtract(u)
			string = pdb[sumvector(ar,0,i-1)+p][17:26]+" "+pdb[sumvector(ar,0,i-1)+p][13:17]+ pdb[sumvector(ar,0,i-1)+p][30:54] +center5d(pdb[sumvector(ar,0,j-1)+q][30:54], pdb[sumvector(ar,0,k-1)+r][30:54], pdb[sumvector(ar,0,l-1)+s][30:54], pdb[sumvector(ar,0,m-1)+t][30:54], pdb[sumvector(ar,0,n-1)+u][30:54]) +" "+ pdb[sumvector(ar,0,i-1)+p][55:66]
			res.append(string)
	return res

#load .pdb file and localize atoms
def hydr_bonds(filename, x, y, z, min_dh_angle, max_dh_angle, min_ah_angle, max_ah_angle):
	


	address = "/home/mmerski/data/HBONDS/PDB_July_5_2016/GENERAL_PACKAGE"
	
	max_dist = 6.0
	min_dist2 = 4.0
	max_dist2 = 36.0

	pdb_prev = []
	with open(address+"/hb_pdb/"+filename) as f:
	    pdb_prev =  f.read().splitlines()

	pdb=[]
	for w in range(0, len(pdb_prev)):
		if pdb_prev[w][0:4] != "ANIS" and pdb_prev[w][:2] != "SI" and pdb_prev[w][:2] != "HE":
			pdb.append(pdb_prev[w])

	pdb.append("END")
	for i in range(0,70):
		pdb += ["ADD_STRING"]
	i=0

	while pdb[i][0:4] != "ATOM" and pdb[i][0:3] != "END":
		i=i+1

	#getting first carbon C
	if pdb[i][0:3] != "END":
		h = i
		prevC_coor=[]
		while pdb[h][13:16]!="CA ":
			h=h+1
		while pdb[h][13:16]=="CA ":
			prevC_coor.append(pdb[h][30:54])
			h=h+1


	#collect data about donors and acceptors
	chains = []
	chains_seq = []
	chain_len = []
	starting_index = []
	curr_chain = pdb[i][21]
	curr_chain_seq = ""
	curr_chain_len = 0
	curr_starting_index = pdb[i][22:26]
	starting_index.append(curr_starting_index)

	listofdon = []
	listofacc = []
	typical_bonds = "N  CA C  O  "
	vect_indices = []
	
	codes_dict = {"CYS":"1ADSG 2CB 1", "ASP":"2ADOD13CG 2ADOD24CG 2", "GLU":"2ADOE14CD 3ADOE25CD 3", "LYS":"1ADNZ 5CE 4", "ASN":"2ADOD13CG 2ADND24CG 2", "GLN":"2ADOE14CD 3ADNE25CD 3", "SER":"1ADOG 2CB 1", "THR":"2ADOG12CB 1-DCG23CB 1", "ARG":"2ADNH16CZ 5ADNH27CZ 5", "TYR":"1ADOH 8CZ 7", "LEU":"2-DCD13CG 2-DCD24CG 2", "MET":"1-DCE 4SD 3", "ILE":"2-DCD14CG12-DCG23CB 1", "ALA":"1-DCB 1CA 1", "VAL":"2-DCG12CB 1-DCG23CB 1"}

	codes2_dict = {"ARG":"ADNE 6", "MET":"A-SG 5"}

	codes4_dict = {"HIS":"4AD65789AD95678AD75689AD85679", "TRP":"2-D85679-D65789"}

	bonds_dict = {"LEU":"CB CG CD1CD2", "ILE":"CB CG1CG2CD1", "ALA":"CB ", "VAL":"CB CG1CG2", "GLY":"", "PHE":"CB CG CD1CD2CE1CE2CZ ", "CYS":"CB SG ", "ASP": "CB CG OD1OD2", "GLU":"CB CG CD OE1OE2", "LYS":"CB CG CD CE NZ ", "ASN":"CB CG OD1ND2", "GLN":"CB CG CD OE1NE2", "SER":"CB OG ", "THR":"CB OG1CG2", "TYR":"CB CG CD1CD2CE1CE2CZ OH ", "TRP":"CB CG CD1CD2NE1CE2CE3CZ2CZ3CH2", "ARG":"CB CG CD NE CZ NH1NH2", "PRO":"CB CG CD ", "MET":"CB CG SD CE ", "HIS":"CB CG ND1CD2CE1NE2"}

	aa_dict = {"ALA":"A", "CYS":"C", "ASP":"D", "GLU": "E", "PHE":"F", "GLY": "G", "HIS":"H", "ILE":"I", "LEU":"L", "LYS": "K", "MET": "M", "ASN": "N", "PRO":"P", "GLN":"Q", "ARG":"R", "SER":"S", "THR":"T", "VAL":"V", "TRP":"W", "TYR":"Y"}

	ar_hb5 = {"HIS":"CG ND1CD2CE1NE2",  "TRP":"CG CD1CD2NE1CE2"}
	ar_hb6 = {"TYR":"CG CD1CD2CE1CE2CZ ", "PHE":"CG CD1CD2CE1CE2CZ "}
	ar_trp_sc = "CD2CE2CE3CZ2CZ3CH2"

	CACGCB = ["ASP","GLU","PHE", "HIS", "LYS", "LEU", "MET", "ASN" ,"PRO", "GLN", "ARG", "SER", "TYR", "TRP", "CYS"]

	while pdb[i][0] != "C" and pdb[i][0] != "E":
	
		if pdb[i][0:4]=="ATOM" and pdb[i][17:20] in bonds_dict:
			
	
			curr_aa = pdb[i][17:20]

			if curr_chain != pdb[i][21]:
				chains.append(curr_chain)
				chains_seq.append(curr_chain_seq)
				chain_len.append(curr_chain_len)
				starting_index.append(pdb[i][22:26])
				curr_chain_len = 0
				curr_chain_seq = ""
				curr_chain = pdb[i][21]

			curr_chain_len = curr_chain_len + 1
			curr_chain_seq = curr_chain_seq + aa_dict[curr_aa]

			curr_index = pdb[i][22:26]
			vect_indices.append(curr_chain + str(int(curr_index)))
			bonds_vect = ""
			start_vect = typical_bonds + bonds_dict[curr_aa]
			length = len(start_vect)
			k = 0
			j = i
			counter = 0

			while (length > 3*k) :
				
				bond = start_vect[3*k:(3*k+3)]
				if pdb[i][13:16] == bond and curr_index==pdb[i][22:26]:
					counter=counter+1
					i=i+1
				else:
					bonds_vect=bonds_vect+str(counter)
					counter=0
					k=k+1

			#N - CA pair for not proline
			if int(bonds_vect[0]) != 0 and int(bonds_vect[1])!=0:
				if curr_aa != "PRO":
					if bonds_vect[0] == bonds_vect[1]:
						for a in range(0, int(bonds_vect[0])):
							if int(curr_index)==1:
								listofdon.append(pdb[j+a][17:26]+" " +pdb[j+a][13:17]+  pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+a][30:54],pdb[j+int(bonds_vect[0])+a][30:54])+ " "+ pdb[j+a][55:66])
								listofacc.append(pdb[j+a][17:26]+" " +pdb[j+a][13:17]+  pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+a][30:54],pdb[j+int(bonds_vect[0])+a][30:54])+ " "+ pdb[j+a][55:66])
							else:
								for index in range(0, len(prevC_coor)):
									listofdon.append(pdb[j+a][17:26]+" " +pdb[j+a][13:17] + pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+a][30:54],prevC_coor[index]) + " "+ pdb[j+int(bonds_vect[0])+a][55:66])
									listofacc.append(pdb[j+a][17:26]+" " +pdb[j+a][13:17] + pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+a][30:54],prevC_coor[index]) + " "+ pdb[j+int(bonds_vect[0])+a][55:66])				
	
					else:
						for a in range(0, int(bonds_vect[0])):
							for b in range(0, int(bonds_vect[1])):
								if int(curr_index)==1:
									listofdon.append(pdb[j+a][17:26]+" " +pdb[j+a][13:17] + pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+b][30:54],pdb[j+int(bonds_vect[0])+b][30:54])+ " "+ pdb[j+a][55:66])
									listofacc.append(pdb[j+a][17:26]+" " +pdb[j+a][13:17] + pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+b][30:54],pdb[j+int(bonds_vect[0])+b][30:54])+ " "+ pdb[j+a][55:66])
								else:
									for index in range(0, len(prevC_coor)):
										listofdon.append(pdb[j+a][17:26]+ " " +pdb[j+a][13:17] +  pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+b][30:54],prevC_coor[index]) + " "+ pdb[j+a][55:66])
										listofdon.append(pdb[j+a][17:26]+ " " +pdb[j+a][13:17] +  pdb[j+a][30:54] + center2d(pdb[j+int(bonds_vect[0])+b][30:54],prevC_coor[index]) + " "+ pdb[j+a][55:66])

			"""
			#N - CD pair for proline
				else:
					jump = 0
					for c in range(0, len(bonds_vect)-1):
						jump = jump + int(bonds_vect[c])
						
					if bonds_vect[0] == bonds_vect[6]:
						for a in range(0, int(bonds_vect[0])):
							listofdon.append(pdb[j+a][17:26]+" "+pdb[j+a][13:17]+ pdb[j+a][30:54] + pdb[j+jump+a][30:54] + " "+ pdb[j+a][55:66])
					else:
						for a in range(0, int(bonds_vect[0])):
							for b in range(0, int(bonds_vect[6])):
								listofdon.append(pdb[j+a][17:26]+" "+pdb[j+a][13:17]+ pdb[j+a][30:54] +pdb[j+jump+b][30:54] + " "+ pdb[j+a][55:66])

			"""
			#prevC_coor
			prevC_coor = []
			jump = int(bonds_vect[0]) + int(bonds_vect[1])
			for c in range(0, int(bonds_vect[2])):
				prevC_coor.append(pdb[j+jump+c][30:54])

			
			#C - 0 pair
			if int(bonds_vect[2]) != 0 and int(bonds_vect[3])!=0:
				jump=jump+int(bonds_vect[2])
				if bonds_vect[2] == bonds_vect[3]:
					for a in range(0, int(bonds_vect[2])):
							listofacc.append(pdb[j+jump+a][17:26]+" "+pdb[j+jump+a][13:17]+ pdb[j+jump+a][30:54] + pdb[j+jump-int(bonds_vect[2])+a][30:54] + " "+ pdb[j+jump+a][55:66])

				else:
					for a in range(0, int(bonds_vect[3])):
						for b in range(0, int(bonds_vect[2])):
							listofacc.append(pdb[j+jump+a][17:26]+" "+pdb[j+jump+a][13:17]+ pdb[j+jump+a][30:54] + pdb[j+jump-int(bonds_vect[2])+b][30:54] + " "+ pdb[j+jump+a][55:66])

			#double_neigh(bonds_vect, i,j,k, pdb)
			if curr_aa in CACGCB:
				listofdon += double_neigh(bonds_vect, 4,1,5, pdb[j:j+70])

			#CA with partners: N, C, CB
			if curr_aa != "GLY":
				p=int(bonds_vect[0])	#N
				q=int(bonds_vect[2])	#C
				r=int(bonds_vect[4])	#CB
				s=int(bonds_vect[1])	#CA
				ar = [p,s,q,r]

				if p>0 and q>0 and r>0 and s>0:
					while (p+q+r+s > 0):
						p=subtract(p)
						q=subtract(q)
						r=subtract(r)
						s=subtract(s)
						string = pdb[j+ar[0]+s][17:26]+" "+pdb[j+ar[0]+s][13:17]+ pdb[j+ar[0]+s][30:54] +center3d(pdb[j+p][30:54], pdb[j+ar[0]+ar[1]+q][30:54], pdb[j+ar[0]+ar[1]+ar[2]+int(bonds_vect[3])+r][30:54]) +" "+ pdb[j+ar[0]+s][55:66]
						listofdon.append(string)


			#special triple cases for carbon bonds
			if curr_aa == "GLU":
				listofdon += double_neigh(bonds_vect, 5,4,6, pdb[j:j+70])
			elif curr_aa == "GLY":
				listofdon += double_neigh(bonds_vect, 1,0,2, pdb[j:j+70])
			elif curr_aa == "ILE":
				listofdon += double_neigh(bonds_vect, 5,4,7, pdb[j:j+70])
				listofdon += triple_neigh(bonds_vect, 4,1,5,6, pdb[j:j+70])
			elif curr_aa == "LYS":
				listofdon += double_neigh(bonds_vect, 6,5,7, pdb[j:j+70])
				listofdon += double_neigh(bonds_vect, 7,6,8, pdb[j:j+70])
				listofdon += double_neigh(bonds_vect, 5,4,6, pdb[j:j+70])
			elif curr_aa == "MET":
				listofdon += double_neigh(bonds_vect, 5,4,6, pdb[j:j+70])
			elif curr_aa == "PRO":
				listofdon += double_neigh(bonds_vect, 6,5,0, pdb[j:j+70])
				listofdon += double_neigh(bonds_vect, 5,4,6, pdb[j:j+70])
			elif curr_aa == "GLN":
				listofdon += double_neigh(bonds_vect, 5,4,6, pdb[j:j+70])
			elif curr_aa == "ARG":
				listofdon += double_neigh(bonds_vect, 5,4,6, pdb[j:j+70])
				listofdon += double_neigh(bonds_vect, 6,5,7, pdb[j:j+70])
			elif curr_aa == "THR":
				listofdon += triple_neigh(bonds_vect, 4,1,5,6, pdb[j:j+70])
			elif curr_aa == "VAL":
				listofdon += triple_neigh(bonds_vect, 4,1,5,6, pdb[j:j+70])
			elif curr_aa == "TRP":
				listofdon += six_neigh(bonds_vect, 10,7,9,11,13,12, pdb[j:j+70])
				listofdon += six_neigh(bonds_vect, 13,7,9,11,10,12, pdb[j:j+70])
				listofdon += six_neigh(bonds_vect, 11,7,9,13,10,12, pdb[j:j+70])
				listofdon += six_neigh(bonds_vect, 12,7,9,11,10,13, pdb[j:j+70])
			elif curr_aa == "LEU":
				listofdon += triple_neigh(bonds_vect, 5,6,7,4, pdb[j:j+70])

			#typical pairs
			if curr_aa in codes_dict:
				for c in range(0, int(codes_dict[curr_aa][0])):
					subcode = codes_dict[curr_aa][(10*c+1):(10*(c+1)+1)]

					p=int(bonds_vect[int(subcode[5])+3])
					q=int(bonds_vect[int(subcode[9])+3])

					argument = int(subcode[9])

					if curr_aa == "ALA":
						q = int(bonds_vect[1])
						argument = -2

					if (p>0) and (q>0):
						jump_p=0
						jump_q=0

						for r in range(0,3+int(subcode[5])):
							jump_p=jump_p+int(bonds_vect[r])

						for r in range(0,3+argument):
							jump_q=jump_q+int(bonds_vect[r])
					
						while (p> 0) or (q> 0):
							p=subtract(p)
							q=subtract(q)
							string=pdb[j+jump_p+p][17:26]+" "+pdb[j+jump_p+p][13:17]+ pdb[j+jump_p+p][30:54] + pdb[j+jump_q+q][30:54]+" "+ pdb[j+jump_p+p][55:66]
							if subcode[0]=="A":
								listofacc.append(string)
							if subcode[1]=="D":
								listofdon.append(string)
							
			
			#[2x]: ARG, MET
			if curr_aa in codes2_dict:
				p=int(bonds_vect[int(codes2_dict[curr_aa][5])]) 	 #CG or CD
				q=int(bonds_vect[1+int(codes2_dict[curr_aa][5])])	 #NE or SD
				r=int(bonds_vect[2+int(codes2_dict[curr_aa][5])])	 #CE or CE

				subcode = codes2_dict[curr_aa]
				if (p>0 and q>0 and r>0):
					jump_p=0
					for s in range(0, int(codes2_dict[curr_aa][5])):
						jump_p = jump_p + int(bonds_vect[s])
					jump_q=jump_p+p
					jump_r=jump_q+q
					while (p>0) or (q>0) or (r>0):
						p=subtract(p)
						q=subtract(q)
						r=subtract(r)
						string = pdb[j+jump_q+q][17:26]+ " " +pdb[j+jump_q+q][13:17]+ pdb[j+jump_q+q][30:54] + center2d(pdb[j+jump_p+p][30:54], pdb[j+jump_r+r][30:54]) + " "+ pdb[j+jump_q+q][55:66]
						if subcode[0]=="A":
							listofacc.append(string)
						if subcode[1]=="D":
							listofdon.append(string)
							
			#[4x]: HIS, TRP +++ ( done) #5-ATOMS AROMATIC BONDS [HIS-5, TRP-5]	
	 		
			if curr_aa in codes4_dict:
				code=codes4_dict[curr_aa]
				for u in range(0, int(code[0])):
					subcode=code[(7*u+1): (7*(u+1)+1)]
				
					p=[]
					q=[]
					for o in range(0,len(bonds_vect)):
						p.append(int(bonds_vect[o]))
						q.append(int(bonds_vect[o]))
					

					jump_5=sumvector(p,0,4)

					if (p[5]>0) and (p[6]>0) and (p[7]>0) and (p[8]>0) and (p[9]>0):
						while (sumvector(p, 5, 9)>0):
							for o in range(5,10):
								p[o] = subtract(p[o])
							v=j+jump_5+sumvector(q,5,int(subcode[2])-1)+p[int(subcode[2])]
							string=pdb[v][17:26]+ " " +pdb[v][13:17] + pdb[v][30:54] + center4d(pdb[j+jump_5+sumvector(q,5,int(subcode[3])-1)+p[int(subcode[3])]][30:54], pdb[j+jump_5+sumvector(q,5,int(subcode[4])-1)+p[int(subcode[4])]][30:54],pdb[j+jump_5+sumvector(q,5,int(subcode[5])-1)+p[int(subcode[5])]][30:54], pdb[j+jump_5+sumvector(q,5,int(subcode[6])-1)+p[int(subcode[6])]][30:54]) + " "+ pdb[v][55:66]
							if subcode[0]=="A":
								listofacc.append(string)
							if subcode[1]=="D":
								listofdon.append(string)
							if u==0:
								listofacc = listofacc + aromatic5(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+p[6]+q[5]][30:54],pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54],pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54],pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54],curr_aa,pdb[v][17:26])
				
				

			#6-ATOMS AROMATIC BONDS [TYR-6, PHE-6]
			if curr_aa in ["TYR", "PHE"]:
				p=[]
				q=[]
				for o in range(0,len(bonds_vect)):
					p.append(int(bonds_vect[o]))
					q.append(int(bonds_vect[o]))

				jump_5=sumvector(p,0,4)

				if (p[5]>0) and (p[6]>0) and (p[7]>0) and (p[8]>0) and (p[9]>0) and (p[10]>0):
					while sumvector(p,5,10)>0:
						for o in range(5,11):
							p[o] = subtract(p[o])
						listofacc = listofacc + aromatic6(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+p[6]+q[5]][30:54],pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54],pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54],pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54], pdb[j+jump_5+p[10]+sumvector(q,5,9)][30:54],curr_aa,pdb[j+jump_5+p[5]][17:26])

						#CD1
						string = pdb[j+jump_5+p[6]+q[5]][17:26]+ " " +pdb[j+jump_5+p[6]+q[5]][13:17]+ pdb[j+jump_5+p[6]+q[5]][30:54] + center5d(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54],pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54],pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54], pdb[j+jump_5+p[10]+sumvector(q,5,9)][30:54]) + " " + pdb[j+jump_5+p[6]+q[5]][55:66]
						listofdon.append(string)
						#CD2 	
						string = pdb[j+jump_5+sumvector(q,5,6)+p[7]][17:26]+ " " +pdb[j+jump_5+sumvector(q,5,6)+p[7]][13:17]+ pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54] + center5d(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+p[6]+q[5]][30:54],pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54],pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54], pdb[j+jump_5+p[10]+sumvector(q,5,9)][30:54]) + " " + pdb[j+jump_5+sumvector(q,5,6)+p[7]][55:66]
						listofdon.append(string)
						#CE2 
						string = pdb[j+jump_5+p[9]+sumvector(q,5,8)][17:26]+ " " +pdb[j+jump_5+p[9]+sumvector(q,5,8)][13:17]+ pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54] + center5d(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+p[6]+q[5]][30:54],pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54],pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54], pdb[j+jump_5+p[10]+sumvector(q,5,9)][30:54]) + " " + pdb[j+jump_5+sumvector(q,5,7) + p[8]][55:66]
						listofdon.append(string)
						#CE1 
						string = pdb[j+jump_5+sumvector(q,5,7) + p[8]][17:26]+ " " +pdb[j+jump_5+sumvector(q,5,7) + p[8]][13:17]+ pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54] + center5d(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+p[6]+q[5]][30:54],pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54],pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54], pdb[j+jump_5+p[10]+sumvector(q,5,9)][30:54]) + " " + pdb[j+jump_5+sumvector(q,5,7) + p[8]][55:66]
						listofdon.append(string)
						if curr_aa == "PHE":
						#CZ 
							string = pdb[j+jump_5+p[10]+sumvector(q,5,9)][17:26]+ " " +pdb[j+jump_5+p[10]+sumvector(q,5,9)][13:17]+ pdb[j+jump_5+p[10]+sumvector(q,5,9)][30:54] + center5d(pdb[j+jump_5+p[5]][30:54],pdb[j+jump_5+p[6]+q[5]][30:54],pdb[j+jump_5+sumvector(q,5,6)+p[7]][30:54],pdb[j+jump_5+p[9]+sumvector(q,5,8)][30:54], pdb[j+jump_5+sumvector(q,5,7) + p[8]][30:54]) + " " + pdb[j+jump_5+sumvector(q,5,7) + p[8]][55:66]
							listofdon.append(string)

			#6-ATOMS AROMATIC BONDS - SPECIAL CASE [TRP-6] WITH MISSING
			if curr_aa in ["TRP"]:
				p=[]
				q=[]
				for o in range(0,len(bonds_vect)):
					p.append(int(bonds_vect[o]))
					q.append(int(bonds_vect[o]))

				jump_7=sumvector(p,0,6)

				if (p[7]>0) and (p[9]>0) and (p[10]>0) and (p[11]>0) and (p[12]>0) and (p[13]>0):
					while sumvector(p,7,13)-p[8]>0:
						for o in [7,9,10,11,12,13]:
							p[o] = subtract(p[o])
						listofacc = listofacc + aromatic6(pdb[j+jump_7+p[7]][30:54],pdb[j+jump_7+p[9]+q[7]+q[8]][30:54],pdb[j+jump_7+sumvector(q,7,9)+p[10]][30:54],pdb[j+jump_7+sumvector(q,7,10) + p[11]][30:54],pdb[j+jump_7+p[12]+sumvector(q,7,11)][30:54], pdb[j+jump_7+p[13]+sumvector(q,7,12)][30:54],curr_aa,pdb[j+jump_7+p[7]][17:26])


			while pdb[i][22:26] == curr_index:
				i=i+1
										
		else:
			i=i+1
	
	chains.append(curr_chain)
	chains_seq.append(curr_chain_seq)
	chain_len.append(curr_chain_len)
	starting_index.append(pdb[i][22:26])

	#check which one fits definition of hydrogen bonds
	#remark: we gonna calculate square of distance as well as just sign of cosine (plus or minus) (it's easier) (it's not true anymore XD)

	CaA=[]
	for acceptor in listofacc:
		xacc=float(acceptor[14:22])
		yacc=float(acceptor[22:30])
		zacc=float(acceptor[30:38])
		xCacc=float(acceptor[38:46])
		yCacc=float(acceptor[46:54])
		zCacc=float(acceptor[54:62])
		CaA.append((xCacc-xacc)*(xCacc-xacc)+(yCacc-yacc)*(yCacc-yacc)+(zCacc-zacc)*(zCacc-zacc))

	#preparing stuff for comparing
	if len(listofdon)>0:
		curr_aaindex = int(listofdon[0][5:9])

	dist_DA = 0
	dist_CaD = 0
	dist_CaA = 0		
	dist_CdD = 0
	dist_CdA = 0
	hydrogen_bonds=[]

	#real party begins
	for donor in listofdon:

		#this line is part of ***HEMISPHERES***
		hres_file = open("./hb_hem/NHB_sph_"+filename[0:4]+".txt","a")


		if int(donor[5:9]) != curr_aaindex:
			curr_aaindex = int(donor[5:9])

		counter_donor=0
	
		xdon=float(donor[14:22])
		ydon=float(donor[22:30])
		zdon=float(donor[30:38])
		xCdon=float(donor[38:46])
		yCdon=float(donor[46:54])
		zCdon=float(donor[54:62])
	
		dist_CdD = (xdon-xCdon)*(xdon-xCdon) + (ydon-yCdon)*(ydon-yCdon) + (zdon-zCdon)*(zdon-zCdon)
		i=0
		for acceptor in listofacc:
	
			xacc=float(acceptor[14:22])
			yacc=float(acceptor[22:30])
			zacc=float(acceptor[30:38])
	
			if(abs(xdon-xacc)<=max_dist and abs(ydon-yacc)<=max_dist and abs(zdon-zacc)<=max_dist) and donor[4] == acceptor[4]:
	
				dist_DA = (xdon-xacc)*(xdon-xacc)+(ydon-yacc)*(ydon-yacc)+(zdon-zacc)*(zdon-zacc)
	
				if dist_DA <= max_dist2 and dist_DA >= min_dist2:
				
					xCacc=float(acceptor[38:46])
					yCacc=float(acceptor[46:54])
					zCacc=float(acceptor[54:62])
					
					dist_CaD=(xCacc-xdon)*(xCacc-xdon)+(yCacc-ydon)*(yCacc-ydon)+(zCacc-zdon)*(zCacc-zdon)
					dist_CaA=CaA[i]
					dist_CdA=(xCdon-xacc)*(xCdon-xacc)+(yCdon-yacc)*(yCdon-yacc)+(zCdon-zacc)*(zCdon-zacc)
					
					cosB_up = (dist_CdD + dist_DA - dist_CdA)/(2*math.sqrt(dist_CdD*dist_DA))
					cosA_up = (dist_CaA + dist_DA - dist_CaD)/(2*math.sqrt(dist_CaA*dist_DA))
					angle_bar = math.cos(math.radians(80))
					dist_DA = math.sqrt(dist_DA)
					cosB = math.acos(cosB_up)
					cosA = math.acos(cosA_up)
					"""dih_ang = dihedral_angle(xdon, ydon, zdon, xCdon, yCdon, zCdon, xacc, yacc, zacc, xCacc, yCacc, zCacc)"""

					code = donor[:13]+" "+acceptor[:13]+" "*(8-len(str(round(dist_DA,4))))+str(round(dist_DA,4))+" "*(8-len(str(round(cosA,4)))) + str(round(cosA,4))+" "*(8-len(str(round(cosB,4)))) + str(round(cosB,4))  + donor[62:73] + acceptor[62:73]  
					""" 
					" "*(8-len(str(round(dih_ang,4)))) + str(round(dih_ang,4))
					""" 


					if (cosB_up <= angle_bar) and (cosA_up <= angle_bar):

						#cosA comparing
						if cosA < min_ah_angle:
							min_ah_angle = cosA
						if cosA > max_ah_angle:
							max_ah_angle = cosA
						#cosB comparing
						if cosB < min_dh_angle:
							min_dh_angle = cosB
						if cosB > max_dh_angle:
							max_dh_angle = cosB

						hydrogen_bonds.append(code)
						hres_file.write(code+" YES\n")
						counter_donor = counter_donor + 1
					else:
						if cosB_up <= angle_bar:
							hres_file.write(code+" NO:WAA\n")	
						elif cosA_up <= angle_bar: 
							hres_file.write(code+" NO:WDA\n")
						elif cosB_up > angle_bar and cosA_up > angle_bar:
							hres_file.write(code+" NO:WDAA\n")
							
				elif dist_DA <= min_dist2 and dist_DA > 0:
					hres_file.write(donor[:13]+" "+acceptor[:13]+" "*(8-len(str(round(dist_DA,4))))+str(round(dist_DA,4))+" "*16 + donor[62:73] + acceptor[62:73] + " NO:SD\n")

			i=i+1
		if counter_donor == 0:
			hydrogen_bonds.append(donor[:13]+ " SOL" +34*" "+ donor[62:73])
			hres_file.write(donor[:13]+ " SOL" +34*" "+ donor[62:73]+ 11*" " + " YES\n")

		#THIS INSTRUCTION IS ADDED FOR ***HEMISPHERES***
		for rzecz in pdb:
			if rzecz[0:4]=="ATOM":

				if rzecz[13:16]=="  C" or rzecz[13:15]==" C" or rzecz[13]=="C":
					dist_DA = math.sqrt((xdon - float(rzecz[30:38]))**2 + (ydon - float(rzecz[38:46]))**2 + (zdon - float(rzecz[46:54]))**2)
					if dist_DA<=6.0 and dist_DA>0:
						hres_file.write(donor[:13]+" "+rzecz[17:26]+" " +rzecz[13:16]+" "*(8-len(str(round(dist_DA,4))))+str(round(dist_DA,4))+" "*16 + donor[62:73] + rzecz[54:65] + " NO:CATOM\n")


				elif rzecz[13:16] == "NE1" or rzecz[13:16] == "ND2" or (rzecz[13:16] == "NE2" and rzecz[17:20]=="GLN"):
					dist_DA = math.sqrt((xdon - float(rzecz[30:38]))**2 + (ydon - float(rzecz[38:46]))**2 + (zdon - float(rzecz[46:54]))**2)
					if dist_DA<=6.0 and dist_DA>0:
						hres_file.write(donor[:13]+" "+rzecz[17:26]+" " +rzecz[13:16]+" "*(8-len(str(round(dist_DA,4))))+str(round(dist_DA,4))+" "*16 + donor[62:73] + rzecz[54:65] + " NO:DONAT\n")
		 
	"""
	chains = []
	chains_seq = []
	chain_len = []
	starting_index = []
	"""

	argument = "NHB_"+filename[0:4]+".txt"
	res_file = open("./hb_res/"+argument,"a")
	

	res_file.write("INFO ABOUT CHAINS AND SEQUENCE" + '\n')

	for i in range(0,len(chains)):
		res_file.write(chains[i] + '\n')
		res_file.write(starting_index[i] + '\n')
		res_file.write(str(chain_len[i]) + '\n')
		res_file.write(chains_seq[i] + '\n')

	if (x=="1"):
		res_file.write("LIST OF DONORS" + '\n')
		for line in listofdon:
			res_file.write(line+'\n')
	if (y=="1"):
		res_file.write("LIST OF ACCEPTORS" + '\n')
		for line in listofacc:
			res_file.write(line+'\n')

	if (z=="1"):
		res_file.write("LIST OF HYDROGEN BONDS" + '\n')
		for line in hydrogen_bonds:
			res_file.write(line+'\n')

	res_file.write("AMINOACIDS NUMBERING:" + '\n')

	for i in range(0, len(vect_indices)):
		res_file.write(str(vect_indices[i]) + '\n') 


	res_file.close()
	MAT_RES = [min_dh_angle, max_dh_angle, min_ah_angle, max_ah_angle]
	return MAT_RES


file_names = "./support/names_sm_tar.txt"

with open(file_names) as f:
    content =  f.read().splitlines()

MAT_RES = [6.30, 0, 6.30, 0]

print "starting hydrogen bond calculation..."
for i in range(0,len(content)):
	print "working on..." + content[i] +", completed in: " + str(float(100.0*i/len(content))) + "%"
	MAT_RES = hydr_bonds(content[i]+".pdb","0","0","1", MAT_RES[0], MAT_RES[1], MAT_RES[2], MAT_RES[3])

print "completed in 100%, preparing angles distribution file..."
angle_file = open("./support/maxminangles.txt","a")
angle_file.write("donor max and min angle attained" + "\n")
angle_file.write(str(MAT_RES[0]) + "\n")
angle_file.write(str(MAT_RES[1]) + "\n")
angle_file.write("acceptor max and min angle attained" + "\n")
angle_file.write(str(MAT_RES[2]) + "\n")
angle_file.write(str(MAT_RES[3]) + "\n")
print "angle distribution file prepared"
